<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

	public function index()
	{
		// $this->load->view('landing_page');
		if ($this->session->userdata('login')) {
			redirect('dashboard','refresh');
		}

		$valid = $this->form_validation;

		$valid->set_rules('email', 'email', 'required');
		$valid->set_rules('password', 'password', 'required');
		$valid->set_message('required', 'Kolom wajib diisi');

		if ($valid->run()) {
			$post = $this->input->post();

			$this->db->join('role', 'id_role', 'left');
			$petugas = $this->db->get_where('petugas', ['email' => $post['email']])->row_array();

			if ($petugas) {

				if (password_verify($post['password'], $petugas['password'])) {

					$session = [
						'login' => true,
						'id_petugas' => $petugas['id_petugas'],
						'id_role' => $petugas['id_role'],
						'id_outlet' => $petugas['id_outlet'],
						'nama_petugas' => $petugas['nama_petugas'],
						'level' => $petugas['nama_role']
					];

					$this->session->set_userdata($session);

					// if ($petugas['id_outlet']) {
					// 	redirect('penjualan','refresh');
					// }
					
					if ($petugas['id_outlet']) {
						redirect('dashboard','refresh');
					}
					redirect('dashboard','refresh');
					
				} else {
					$this->session->set_flashdata('error', 'Password anda salah');
					redirect('login','refresh');
				}
				
			}else{
				$this->session->set_flashdata('error', 'Email tidak ditemukan');
				redirect('login','refresh');
			}
		}

		$this->load->view('auth/login');
	}
}
